"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _AuthType = _interopRequireDefault(require("../AuthType"));
var _missing_tenant_error = _interopRequireDefault(require("../../errors/missing_tenant_error"));
var _session_expired_error = _interopRequireDefault(require("../../errors/session_expired_error"));
var _missing_role_error = _interopRequireDefault(require("../../errors/missing_role_error"));
var _path = _interopRequireDefault(require("path"));
var _AuthManager = require("../../AuthManager");
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2018 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

class Jwt extends _AuthType.default {
  constructor({
    searchGuardBackend,
    kibanaCore,
    config,
    logger,
    sessionStorageFactory,
    pluginDependencies,
    spacesService
  }) {
    super({
      searchGuardBackend,
      kibanaCore,
      config,
      logger,
      sessionStorageFactory,
      pluginDependencies,
      spacesService
    });

    /**
     * The authType is saved in the auth cookie for later reference
     * @type {string}
     */
    this.type = _AuthManager.AUTH_TYPE_NAMES.JWT;
    this.loginURL = null;
  }

  /*
  debugLog(message, label = AUTH_TYPE_NAMES.JWT) {
    super.debugLog(message, label);
  }
    */

  async detectCredentialsByRequest({
    request
  }) {
    if (!this.config.get('searchguard.auth.jwt_param.enabled')) {
      return null;
    }
    const urlparamname = this.config.get('searchguard.auth.jwt_param.url_param').toLowerCase();

    // Go through all given query parameters and make them lowercase
    // to avoid confusion when using uppercase or perhaps mixed caps
    const lowerCaseQueryParameters = {};
    request.url.searchParams.forEach((value, key) => {
      lowerCaseQueryParameters[key.toLowerCase()] = value;
    });
    const jwtAuthParam = lowerCaseQueryParameters[urlparamname] || null;
    if (jwtAuthParam) {
      const credentials = {
        mode: 'jwt',
        jwt: jwtAuthParam
      };
      this.debugLog('JWT from url parameter: ' + jwtAuthParam);
      return credentials;
    }
    return null;
  }
  async getRedirectTargetForUnauthenticated(request, error = null, isAJAX = false) {
    let url = new URL(request.url.href);
    url.pathname = _path.default.posix.join(this.basePath, '/customerror');

    // Missing tenant or role takes precedence
    if (error instanceof _missing_tenant_error.default) {
      url.searchParams.set('type', 'missingTenant');
    } else if (error instanceof _missing_role_error.default) {
      url.searchParams.set('type', 'missingRole');
    } else {
      const authConfig = (await this.searchGuardBackend.getAuthConfig()).auth_methods.find(config => config.method === 'link');

      // The customer may use a login endpoint, to which we can redirect
      // if the user isn't authenticated.
      const loginEndpoint = authConfig ? authConfig.sso_location : null;
      if (loginEndpoint) {
        try {
          const sessionCookie = (await this.sessionStorageFactory.asScoped(request).get()) || {};
          // Delete this again, otherwise the user won't get back to the login page
          // if trying to access Kibana again
          delete sessionCookie.authTypeId;
          delete sessionCookie.authType;
          await this.sessionStorageFactory.asScoped(request).set(sessionCookie);

          // Parse the login endpoint so that we can append our nextUrl
          // if the customer has defined query parameters in the endpoint
          url = new URL(loginEndpoint);

          // Make sure we don't overwrite an existing "nextUrl" parameter,
          // just in case the customer is using that name for something else
          // Also, we don't want the nextUrl if this is an AJAX request.
          if (!isAJAX && !url.searchParams.has('nextUrl')) {
            url.searchParams.set('nextUrl', this.getNextUrl(request));
            // Delete sg_tenant because we have it already as a param in the nextUrl
            url.searchParams.delete('sg_tenant');
          }
          return url.toString();
        } catch (error) {
          this.logger.error('An error occured while parsing the searchguard.jwt.login_endpoint value');
        }
      }
    }
    return url.pathname + url.search + url.hash;
  }
  setupRoutes() {
    require('./routes')({
      authInstance: this,
      kibanaCore: this.kibanaCore,
      logger: this.logger
    });
  }
}
exports.default = Jwt;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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